USE direct;
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[admin_contact_list]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[admin_contact_list](
	[contact_id] [bigint] IDENTITY(1,1) NOT NULL,
	[first_name] [nvarchar](max) NOT NULL,
	[middle_name] [nvarchar](max) NULL,
	[last_name] [nvarchar](max) NOT NULL,
	[title] [nvarchar](max) NULL,
	[department] [nvarchar](max) NULL,
	[organization] [nvarchar](max) NULL,
	[telephone] [nvarchar](50) NULL,
	[sharing] [nvarchar](max) NOT NULL,
	[direct_address] [nvarchar](max) NOT NULL,
	[mobile] [nvarchar](50) NULL,
 CONSTRAINT [PK_admin_contact_list] PRIMARY KEY CLUSTERED ([contact_id] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
END
SET ANSI_PADDING OFF

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[das_results]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[das_results](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[created_by] [nvarchar](max) NULL,
	[saved_date] [bigint] NULL,
	[result_status] [nchar](10) NULL,
	[attachment_name] [nvarchar](max) NULL,
	[hash_attachment_name] [nvarchar](512) NULL,
	[das_document_id] [nvarchar](max) NULL,
	[message_id] [bigint] NULL,
CONSTRAINT [PK_das_results] PRIMARY KEY CLUSTERED ([id] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
END
SET ANSI_PADDING OFF

USE api;
INSERT [dbo].[permissions] ([name], [parent_id]) VALUES (N'adhoc_reports_report', 1);
ALTER TABLE users ALTER COLUMN username nvarchar(50);
ALTER TABLE account_request ALTER COLUMN username nvarchar(100);
ALTER TABLE account_request ALTER COLUMN justification nvarchar(4000);
ALTER TABLE application ALTER COLUMN name nvarchar(100);
ALTER TABLE application ALTER COLUMN public_key nvarchar(100);
ALTER TABLE application ALTER COLUMN private_key nvarchar(100);
ALTER TABLE application ALTER COLUMN url nvarchar(1000);
ALTER TABLE application ALTER COLUMN description nvarchar(4000);
ALTER TABLE application ALTER COLUMN poc_name nvarchar(500);
ALTER TABLE application ALTER COLUMN poc_email nvarchar(100);
ALTER TABLE application ALTER COLUMN poc_phone nvarchar(20);
ALTER TABLE application_account_link ALTER COLUMN unique_id nvarchar(64);
ALTER TABLE application_request ALTER COLUMN name nvarchar(100);
ALTER TABLE application_request ALTER COLUMN url nvarchar(1000);
ALTER TABLE application_request ALTER COLUMN description nvarchar(4000);
ALTER TABLE application_request ALTER COLUMN poc_name nvarchar(500);
ALTER TABLE application_request ALTER COLUMN poc_email nvarchar(100);
ALTER TABLE application_request ALTER COLUMN poc_phone nvarchar(20);
ALTER TABLE application_request ALTER COLUMN justification nvarchar(4000);
ALTER TABLE application_request ALTER COLUMN denial_reason nvarchar(4000);
ALTER TABLE facility ALTER COLUMN name nvarchar(400);
ALTER TABLE mail_log ALTER COLUMN sender nvarchar(max);
ALTER TABLE mail_log ALTER COLUMN recipient nvarchar(max);
ALTER TABLE request ALTER COLUMN call nvarchar(max);
ALTER TABLE request ALTER COLUMN response nvarchar(max);
ALTER TABLE ticket_category ALTER COLUMN category nvarchar(200);
ALTER TABLE tickets ALTER COLUMN message nvarchar(4000);
ALTER TABLE web_services ALTER COLUMN name nvarchar(200);
ALTER TABLE web_services ALTER COLUMN description nvarchar(4000);
ALTER TABLE role_permissions ALTER COLUMN role_name nvarchar(150);
ALTER TABLE permissions ALTER COLUMN name nvarchar(100);

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[adhoc_reports](
	[report_id] [bigint] IDENTITY(1,1) NOT NULL,
	[report_type] [nvarchar](100) NULL,
	[report_name] [nvarchar](50) NULL,
	[report_description] [nvarchar](max) NULL,
	[report_created_by] [nvarchar](max) NULL,
	[report_access_type] [nvarchar](50) NULL,
	[report_created_time] [bigint] NOT NULL,
	[report_query_generator] [nvarchar](max) NULL,
	[report_order_by] [nvarchar](max) NULL,
	[report_order_by_direction] [nvarchar](100) NULL,
	[report_time_period] [nvarchar](200) NULL,
	[report_status] [nvarchar](max) NULL,
	[report_end_date] [nvarchar](max) NULL,
	[report_start_date] [nvarchar](max) NULL,
	[report_selector] [nvarchar](max) NULL,
	[report_time_field] [nvarchar](200) NULL
CONSTRAINT [PK_adhoc_reports] PRIMARY KEY CLUSTERED ([report_id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
SET ANSI_PADDING OFF

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[adhoc_reports_access](
	[report_access_id] [bigint] IDENTITY(1,1) NOT NULL,
	[report_id] [bigint] NOT NULL,
	[user_id] [bigint] NOT NULL,
	[time] [bigint] NOT NULL
CONSTRAINT [PK_adhoc_reports_access] PRIMARY KEY CLUSTERED ([report_access_id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
SET ANSI_PADDING OFF
																	
USE mail;
DECLARE @SQL nvarchar(max);
SET @SQL = 'ALTER TABLE mailboxes DROP CONSTRAINT ' + (SELECT name FROM sys.objects WHERE type = 'UQ' AND parent_object_id = OBJECT_ID(N'[dbo].[mailboxes]'));
EXEC(@SQL);
ALTER TABLE mailboxes ALTER COLUMN name nvarchar(100);
ALTER TABLE mailboxes ADD CONSTRAINT UQ_mailboxes_name UNIQUE NONCLUSTERED (name);
ALTER TABLE folders ALTER COLUMN name nvarchar(200);
ALTER TABLE messages ALTER COLUMN recipients nvarchar(max);
ALTER TABLE messages ALTER COLUMN sender nvarchar(max);
ALTER TABLE messages ALTER COLUMN [to] nvarchar(max);
ALTER TABLE messages ALTER COLUMN cc nvarchar(max);
ALTER TABLE messages ALTER COLUMN bcc nvarchar(max);
ALTER TABLE messages ALTER COLUMN attachments nvarchar(max);
ALTER TABLE messages ALTER COLUMN subject nvarchar(max);
ALTER TABLE messages ALTER COLUMN plain nvarchar(max);
ALTER TABLE messages ALTER COLUMN html nvarchar(max);
ALTER TABLE messages ALTER COLUMN flags nvarchar(max);
ALTER TABLE messages ALTER COLUMN headers nvarchar(max);
ALTER TABLE messages ALTER COLUMN raw_mime nvarchar(max);
ALTER TABLE messages ALTER COLUMN message_id nvarchar(max);
SET @SQL = 'ALTER TABLE messages DROP CONSTRAINT ' + (SELECT default_constraints.name FROM sys.all_columns INNER JOIN sys.tables ON all_columns.object_id = tables.object_id INNER JOIN sys.schemas ON tables.schema_id = schemas.schema_id INNER JOIN sys.default_constraints ON all_columns.default_object_id = default_constraints.object_id WHERE schemas.name = 'dbo' AND tables.name = 'messages' AND all_columns.name = 'mailtype');
EXEC(@SQL);
ALTER TABLE messages ALTER COLUMN mailtype nvarchar(4);

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
CREATE TABLE [dbo].[message_status](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[message_id] [nvarchar](max) NOT NULL,
	[status_code] [tinyint] NOT NULL,
	[recipient] [nvarchar](max) NOT NULL,
	[timestamp] [bigint] NOT NULL,
 CONSTRAINT [PK_message_status] PRIMARY KEY CLUSTERED ([id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
SET ANSI_PADDING OFF

SET ANSI_NULLS ON	
SET QUOTED_IDENTIFIER ON	
SET ANSI_PADDING ON
CREATE TABLE [dbo].[accounting_disclosure](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[messages_table_id] [bigint] NOT NULL,
	[message_id] [nvarchar](max) NULL,
	[recipient] [nvarchar](max) NOT NULL,
	[first] [nvarchar](max) NULL,
	[last] [nvarchar](max) NULL,
	[disclosed] [bigint] NOT NULL,
	[received] [bigint] NULL,
	[title] [nvarchar](max) NULL,
	[sent_to] [nvarchar](max) NULL,
	[received_from] [nvarchar](max) NULL,
	[username] [nvarchar](100) NOT NULL,
	[facility] [nvarchar](max) NULL,
	[purpose] [nvarchar](max) NULL,
	[ssn] [bigint] NULL,
	[hash] [nchar](40) NOT NULL,
	[patient_id] [nvarchar](50) NULL,
 CONSTRAINT [PK_accounting_disclosures] PRIMARY KEY CLUSTERED ([id] ASC)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
SET ANSI_PADDING OFF
ALTER TABLE [dbo].[accounting_disclosure]  WITH CHECK ADD  CONSTRAINT [FK_accounting_disclosures_mailboxes] FOREIGN KEY([username]) REFERENCES [dbo].[mailboxes] ([name])
ALTER TABLE [dbo].[accounting_disclosure] CHECK CONSTRAINT [FK_accounting_disclosures_mailboxes]
ALTER TABLE [dbo].[accounting_disclosure]  WITH CHECK ADD  CONSTRAINT [FK_accounting_disclosures_messages] FOREIGN KEY([messages_table_id]) REFERENCES [dbo].[messages] ([id])
ALTER TABLE [dbo].[accounting_disclosure] CHECK CONSTRAINT [FK_accounting_disclosures_messages]	


